//  ****************************************************************
//  ****************************************************************
//	****														****
//	****	sonstige Funktionen fr Digitalanzeige				****
//	****														****
//  ****************************************************************
//  ****************************************************************

//**********************************************************
//****
//**** PIC Initialisierung
//****
//**********************************************************

void InitPic(void)   
{  
 // Portinitialisierung	

   INT1IF=0;
   INTCON=0;
   INTCON2=0;
   OSCCON=0x60;						// 4 Mhz interner Clock
   LATA=PortA_Init;
   LATB=PortB_Init;
   LATC=PortC_Init;
   LATD=PortD_Init;
   LATE=PortE_Init;			
				
   TRISA=TrisA_Config;
   TRISB=TrisB_Config;
   TRISC=TrisC_Config;
   TRISD=TrisD_Config;
   TRISE=TrisE_Config;
   
   // Analogeingnge
   ADCON0=AD_config0;
   ADCON1=AD_config1;
   ADCON2=AD_config2;
   CMCON=Comp_Config;

   // UART-Init
   
   SPBRG=SPBRG_Config;
   RCSTA=RCSTA_Config; 
   TXSTA=TXSTA_Config; 

  // SPI
   SetUp_SPI(SPI_MASTER|SPI_H_TO_L|SPI_CLK_DIV_4);
   CVREN=0;									// Voltage Referenz disabled
   HLVDEN=0;								// Low Voltage detect Module disabled
   
   // Timer
   T0CON=T0_On_Config;
   CCPR1L=0;
   CCPR2L=0xFF;								// DutyCycle>Periode --> immer auf High
   CCP1CON=CCP1_Config;
   PWM1CON=PWM1_Config;
   ECCPASE=ECC_CONFIG;
   CCP2CON=CCP2_Config;
   
   // Interrupts
   IntCon2=IntCon2_Config;
   IntCon3=IntCon3_Config;	
   IntCon=Intcon_Config;
   PIE1=PIE1_Config;
   IPR1=0;
   IPR2=0;
   PLLEN=1;									// 16MHz System Clock --> 4MHz SPI

}

//***********************************************************************
//****														
//****	Messwert in mm-String umwandeln
//****  V ist Int32, Wertebereich 0..2047999 (9999,99952mm)
//****  fhrende Nullen (bis auf Einer) werden durch Leerzeichen ersetzt
//****  2 Nachkommastellen, wenn #define DezimalDigits2 sonst 3
//****															
//***********************************************************************

void ValueToMM(char *mmstr, signed int32 V)
{ int32 temp,x;
  short negative=false;
  short Uebertrag=false;

  if(V<0) {V=0-V; negative=true;}
  if(V<20480000) temp=V; else Temp=20479999;

  mmstr[0]=0x20;

  // Nachkommastellen
  if(V<20480000) temp=V; else Temp=20479999;
  temp%=2048; Temp*=10000; Temp/=2048;
  // Rundungstrick
  #ifdef DezimalDigits2
	temp=temp+50;
  #else
	temp=temp+5;
  #endif

  mmStr[5]=',';
  x=Temp/1000;
  if(x==10) {X=0; Uebertrag=true;}
  Temp%=1000; mmstr[6]=x+0x30;											// Zentel 
  x=Temp/100; Temp%=100;
  mmstr[7]=x+0x30;														// Hundertstel 
  #ifdef DezimalDigits2
    mmstr[8]='m'; mmstr[9]='m'; mmstr[10]=0;
  #else
    x=Temp/10; Temp%=10;
    mmstr[8]=x+0x30;													// Tausendstel 
    mmstr[9]='m'; mmstr[10]='m'; mmstr[11]=0;
  #endif

  // Vorkommastellen
  if(V<20480000) temp=V; else Temp=20479999;
  Temp/=2048;
  if(Uebertrag) temp++;													// bertrag bei Nachkommastellen verrechnen
  x=Temp/1000; Temp%=1000;						
  if (x==0) mmstr[1]=0x20; else mmstr[1]=x+0x30;						// Tausender Stelle 
  x=Temp/100; Temp%=100;						
  if ((x==0)&&(mmStr[1]==0x20)) mmstr[2]=0x20; else mmstr[2]=x+0x30;	// Hunderter Stelle 
  x=Temp/10; Temp%=10;						
  if ((x==0)&&(mmStr[2]==0x20)) mmstr[3]=0x20; else mmstr[3]=x+0x30;	// Zehner Stelle 
  mmstr[4]=Temp+0x30;													// Einer Stelle 

  // Vorzeichen
  if(negative)
  { #asm nop #endasm
	if(mmstr[3]==0x20)
	  mmstr[3]=0x2D;
	else
	  if(mmstr[2]==0x20)
	    mmstr[2]=0x2D;
	  else
	    if(mmstr[1]==0x20)
	      mmstr[1]=0x2D;
 		else
		  mmstr[0]=0x2D;
  }
#asm nop #endasm
}

//  ********************************************************************
//	****														
//	****	Tasten abfragen
//	****										
//  ********************************************************************
int getTaste()
{ int Taste=0;

  if(!Taste3) Taste=4;
#ifdef Debug
#else								// Tasten 1 & 2 im Debug-Modus nicht nutzbar
  if(!Taste2) Taste=3;
  if(!Taste1) Taste=2;
#endif
  if(!Enc_BT) Taste=1;
  return(Taste);
}

//  ********************************************************************
//	****														
//	****	Parameter im EEPROM ablegen
//	****										
//  ********************************************************************

void StoreParameter()
{ int h,l;
  Write_EEPROM(0,(XOffset&0xFF));Write_EEPROM(1,(XOffset>>8));
  Write_EEPROM(2,(YOffset&0xFF));Write_EEPROM(3,(YOffset>>8));
  Write_EEPROM(4,(ZOffset&0xFF));Write_EEPROM(5,(ZOffset>>8));
  Write_EEPROM(6,MaschType);								// Maschinentyp 0 --> Frsmaschine / 1 --> Drehmaschine

}

//  ********************************************************************
//	****														
//	****	Parameter aus EEPROM lesen
//	****										
//  ********************************************************************

void ReadParameter()
{ int h,l;
  l=Read_EEPROM(0); h=Read_EEPROM(1);
  XOffset=H; XOffset*=0x100; XOffset+=l;				// Offsetwerte fr Anzeige in mm
  l=Read_EEPROM(2); h=Read_EEPROM(3);
  YOffset=H; YOffset*=0x100; YOffset+=l;				// Offsetwerte fr Anzeige in mm
  l=Read_EEPROM(4); h=Read_EEPROM(5);
  ZOffset=H; ZOffset*=0x100; ZOffset+=l;				// Offsetwerte fr Anzeige in mm
  MaschType=Read_EEPROM(6);								// Maschinentyp 0 --> Frsmaschine / 1 --> Drehmaschine

}
